/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lotr.common.LOTRLevelData;
import lotr.common.fac.LOTRFaction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.UsernameCache;
import org.apache.commons.lang3.StringUtils;

public class LOTRFactionBounties {
    public static Map<LOTRFaction, LOTRFactionBounties> factionBountyMap = new HashMap<LOTRFaction, LOTRFactionBounties>();
    public static boolean needsLoad = true;
    public static final int KILL_RECORD_TIME = 3456000;
    public static final int BOUNTY_KILLED_TIME = 864000;
    public final LOTRFaction theFaction;
    private Map<UUID, PlayerData> playerList = new HashMap<UUID, PlayerData>();
    private boolean needsSave = false;

    public static LOTRFactionBounties forFaction(LOTRFaction fac) {
        LOTRFactionBounties bounties = factionBountyMap.get((Object)fac);
        if (bounties == null) {
            bounties = LOTRFactionBounties.loadFaction(fac);
            if (bounties == null) {
                bounties = new LOTRFactionBounties(fac);
            }
            factionBountyMap.put(fac, bounties);
        }
        return bounties;
    }

    public static void updateAll() {
        for (LOTRFactionBounties fb : factionBountyMap.values()) {
            fb.update();
        }
    }

    public LOTRFactionBounties(LOTRFaction f) {
        this.theFaction = f;
    }

    public PlayerData forPlayer(EntityPlayer entityplayer) {
        return this.forPlayer(entityplayer.func_110124_au());
    }

    public PlayerData forPlayer(UUID id) {
        PlayerData pd = this.playerList.get(id);
        if (pd == null) {
            pd = new PlayerData(this, id);
            this.playerList.put(id, pd);
        }
        return pd;
    }

    public void update() {
        for (PlayerData pd : this.playerList.values()) {
            pd.update();
        }
    }

    public List<PlayerData> findBountyTargets(int killAmount) {
        ArrayList<PlayerData> players = new ArrayList<PlayerData>();
        for (PlayerData pd : this.playerList.values()) {
            if (pd.recentlyBountyKilled() || pd.getNumKills() < killAmount) continue;
            players.add(pd);
        }
        return players;
    }

    public void markDirty() {
        this.needsSave = true;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList playerTags = new NBTTagList();
        for (Map.Entry<UUID, PlayerData> e : this.playerList.entrySet()) {
            UUID id = e.getKey();
            PlayerData pd = e.getValue();
            if (!pd.shouldSave()) continue;
            NBTTagCompound playerData = new NBTTagCompound();
            playerData.func_74778_a("UUID", id.toString());
            pd.writeToNBT(playerData);
            playerTags.func_74742_a((NBTBase)playerData);
        }
        nbt.func_74782_a("PlayerList", (NBTBase)playerTags);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.playerList.clear();
        if (nbt.func_74764_b("PlayerList")) {
            NBTTagList playerTags = nbt.func_150295_c("PlayerList", 10);
            for (int i = 0; i < playerTags.func_74745_c(); ++i) {
                NBTTagCompound playerData = playerTags.func_150305_b(i);
                UUID id = UUID.fromString(playerData.func_74779_i("UUID"));
                if (id == null) continue;
                PlayerData pd = new PlayerData(this, id);
                pd.readFromNBT(playerData);
                this.playerList.put(id, pd);
            }
        }
    }

    public static boolean anyDataNeedsSave() {
        for (LOTRFactionBounties fb : factionBountyMap.values()) {
            if (!fb.needsSave) continue;
            return true;
        }
        return false;
    }

    private static File getBountiesDir() {
        File dir = new File(LOTRLevelData.getOrCreateLOTRDir(), "factionbounties");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static File getFactionFile(LOTRFaction f, boolean findLegacy) {
        File defaultFile = new File(LOTRFactionBounties.getBountiesDir(), f.codeName() + ".dat");
        if (!findLegacy) {
            return defaultFile;
        }
        if (defaultFile.exists()) {
            return defaultFile;
        }
        for (String alias : f.listAliases()) {
            File aliasFile = new File(LOTRFactionBounties.getBountiesDir(), alias + ".dat");
            if (!aliasFile.exists()) continue;
            return aliasFile;
        }
        return defaultFile;
    }

    public static void saveAll() {
        try {
            for (LOTRFactionBounties fb : factionBountyMap.values()) {
                if (!fb.needsSave) continue;
                LOTRFactionBounties.saveFaction(fb);
                fb.needsSave = false;
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error saving LOTR faction bounty data", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void loadAll() {
        try {
            factionBountyMap.clear();
            needsLoad = false;
            LOTRFactionBounties.saveAll();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error loading LOTR faction bounty data", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private static LOTRFactionBounties loadFaction(LOTRFaction fac) {
        File file = LOTRFactionBounties.getFactionFile(fac, true);
        try {
            NBTTagCompound nbt = LOTRLevelData.loadNBTFromFile(file);
            if (nbt.func_82582_d()) {
                return null;
            }
            LOTRFactionBounties fb = new LOTRFactionBounties(fac);
            fb.readFromNBT(nbt);
            return fb;
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error loading LOTR faction bounty data for %s", (Object[])new Object[]{fac.codeName()});
            e.printStackTrace();
            return null;
        }
    }

    private static void saveFaction(LOTRFactionBounties fb) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            fb.writeToNBT(nbt);
            LOTRLevelData.saveNBTToFile(LOTRFactionBounties.getFactionFile(fb.theFaction, false), nbt);
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error saving LOTR faction bounty data for %s", (Object[])new Object[]{fb.theFaction.codeName()});
            e.printStackTrace();
        }
    }

    public static class PlayerData {
        public final LOTRFactionBounties bountyList;
        public final UUID playerID;
        private String username;
        private List<KillRecord> killRecords = new ArrayList<KillRecord>();
        private int recentBountyKilled;

        public PlayerData(LOTRFactionBounties b, UUID id) {
            this.bountyList = b;
            this.playerID = id;
        }

        public void recordNewKill() {
            this.killRecords.add(new KillRecord());
            this.markDirty();
        }

        public int getNumKills() {
            return this.killRecords.size();
        }

        public void recordBountyKilled() {
            this.recentBountyKilled = 864000;
            this.markDirty();
        }

        public boolean recentlyBountyKilled() {
            return this.recentBountyKilled > 0;
        }

        public void update() {
            boolean minorChanges = false;
            if (this.recentBountyKilled > 0) {
                --this.recentBountyKilled;
                minorChanges = true;
            }
            ArrayList<KillRecord> toRemove = new ArrayList<KillRecord>();
            for (KillRecord kr : this.killRecords) {
                kr.timeElapsed--;
                if (kr.timeElapsed <= 0) {
                    toRemove.add(kr);
                }
                minorChanges = true;
            }
            if (!toRemove.isEmpty()) {
                this.killRecords.removeAll(toRemove);
                minorChanges = true;
            }
            if (minorChanges && MinecraftServer.func_71276_C().func_71259_af() % 600 == 0) {
                this.markDirty();
            }
        }

        private void markDirty() {
            this.bountyList.markDirty();
        }

        public boolean shouldSave() {
            return !this.killRecords.isEmpty() || this.recentBountyKilled > 0;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagList recordTags = new NBTTagList();
            for (KillRecord kr : this.killRecords) {
                NBTTagCompound killData = new NBTTagCompound();
                kr.writeToNBT(killData);
                recordTags.func_74742_a((NBTBase)killData);
            }
            nbt.func_74782_a("KillRecords", (NBTBase)recordTags);
            nbt.func_74768_a("RecentBountyKilled", this.recentBountyKilled);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.killRecords.clear();
            if (nbt.func_74764_b("KillRecords")) {
                NBTTagList recordTags = nbt.func_150295_c("KillRecords", 10);
                for (int i = 0; i < recordTags.func_74745_c(); ++i) {
                    NBTTagCompound killData = recordTags.func_150305_b(i);
                    KillRecord kr = new KillRecord();
                    kr.readFromNBT(killData);
                    this.killRecords.add(kr);
                }
            }
            this.recentBountyKilled = nbt.func_74762_e("RecentBountyKilled");
        }

        public String findUsername() {
            if (this.username == null) {
                GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(this.playerID);
                if (profile == null || StringUtils.isBlank((CharSequence)profile.getName())) {
                    String name = UsernameCache.getLastKnownUsername((UUID)this.playerID);
                    if (name != null) {
                        profile = new GameProfile(this.playerID, name);
                    } else {
                        profile = new GameProfile(this.playerID, "");
                        MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(profile, true);
                    }
                }
                this.username = profile.getName();
            }
            return this.username;
        }

        private static class KillRecord {
            private int timeElapsed = 3456000;

            private KillRecord() {
            }

            public void writeToNBT(NBTTagCompound nbt) {
                nbt.func_74768_a("Time", this.timeElapsed);
            }

            public void readFromNBT(NBTTagCompound nbt) {
                this.timeElapsed = nbt.func_74762_e("Time");
            }
        }
    }
}

